// Persistence of Vision Ray Tracer Include File
// File: bead_properties.inc
// Vers: 3.6
// Desc: Include file for the Beads'N'Wires project
// Date: Sept-Oct 2004
// Auth: Maurice Hendrix

// original textures and pigments borrowed from T_Wood7 (woods.inc) and adapted

//wood grain for the beads
#declare P_BeadA =
pigment {
    wood
    turbulence <0.05, 0.08, 1000>
    octaves 4
    scale <0.15, .15, 1>
}

#declare P_BeadB =
pigment {
    bozo
    scale <0.01, 0.01, 100000>
}

// Colormaps for the beads
#declare M_BeadA = 
color_map { 
    [0.0, 0.1 color rgb <0.60, 0.35, 0.20>
              color rgb <0.60, 0.35, 0.20>]
    [0.1, 0.9 color rgb <0.60, 0.35, 0.20>
              color rgb <0.90, 0.65, 0.30>]
    [0.9, 1.0 color rgb <0.90, 0.65, 0.30>
              color rgb <0.60, 0.35, 0.20>]
}

#declare M_BeadB = 
color_map { 
    [0.0, 0.1 color rgbt <0.90, 0.65, 0.30, 0.00>
              color rgbt <0.90, 0.65, 0.30, 0.30>]
    [0.1, 1.0 color rgbt <0.90, 0.65, 0.30, 0.30>
              color rgbt <1.00, 1.00, 1.00, 1.00> ] 
}

#declare M_BeadB_R = 
color_map { 
    [0.0, 0.8 color rgbt <1, 0, 0, 0.00>
              color rgbt <1, 0, 0, 0.20>]
    [0.8, 1.0 color rgbt <1, 0, 0, 0.20>
              color rgbt <1, 0, 0, 1.00> ] 
}

#declare M_BeadB_G = 
color_map { 
    [0.0, 0.8 color rgbt <0, .8, 0, 0.00>
              color rgbt <0, .8, 0, 0.20>]
    [0.8, 1.0 color rgbt <0, .8, 0, 0.20>
              color rgbt <0, .8, 0, 1.00> ] 
}

#declare M_BeadB_B = 
color_map { 
    [0.0, 0.8 color rgbt <0, 0, 1, 0.00>
              color rgbt <0, 0, 1, 0.20>]
    [0.8, 1.0 color rgbt <0, 0, 1, 0.20>
              color rgbt <0, 0, 1, 1.00> ] 
}


#declare M_BeadB_Y = 
color_map { 
    [0.0, 0.8 color rgbt <1, 1, 0, 0.00>
              color rgbt <1, 1, 0, 0.20>]
    [0.8, 1.0 color rgbt <1, 1, 0, 0.20>
              color rgbt <1, 1, 0, 1.00> ] 
}

#declare M_BeadB_M = 
color_map { 
    [0.0, 0.8 color rgbt <1, 0, 1, 0.00>
              color rgbt <1, 0, 1, 0.20>]
    [0.8, 1.0 color rgbt <1, 0, 1, 0.20>
              color rgbt <1, 0, 1, 1.00> ] 
}

#declare M_BeadB_C = 
color_map { 
    [0.0, 0.8 color rgbt <0, .8, .8, 0.00>
              color rgbt <0, .8, .8, 0.20>]
    [0.8, 1.0 color rgbt <0, .8, .8, 0.20>
              color rgbt <0, .8, .8, 1.00> ] 
}


// Texture for the beads
#declare RedBead   =         
   texture { pigment { P_BeadA  color_map { M_BeadA }}} 
   texture { pigment { P_BeadB  color_map { M_BeadB_R }}}

#declare BlueBead   =         
   texture { pigment { P_BeadA  color_map { M_BeadA }}} 
   texture { pigment { P_BeadB  color_map { M_BeadB_B }}}
   

#declare GreenBead   =         
   texture { pigment { P_BeadA  color_map { M_BeadA }}} 
   texture { pigment { P_BeadB  color_map { M_BeadB_G }}}
   
#declare CyanBead   =         
   texture { pigment { P_BeadA  color_map { M_BeadA }}} 
   texture { pigment { P_BeadB  color_map { M_BeadB_C }}}
   
#declare YellowBead   =         
   texture { pigment { P_BeadA  color_map { M_BeadA }}} 
   texture { pigment { P_BeadB  color_map { M_BeadB_Y }}}

#declare MagentaBead   =         
   texture { pigment { P_BeadA  color_map { M_BeadA }}} 
   texture { pigment { P_BeadB  color_map { M_BeadB_M }}}

#declare T_Bead   =         
   texture { pigment { P_BeadA  color_map { M_BeadA }}} 
   texture { pigment { P_BeadB  color_map { M_BeadB }}}

  
#declare bead_F=
  finish {
    ambient 0.1
    diffuse 0.6
    specular 0.2 roughness 0.03
    phong 0.2 phong_size 24
    reflection{0.015 }
  }

